<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Site extends Model 
{

    protected $table = 'sites';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function users()
    {
        return $this->hasMany('App\Model\UserSite');
    }

    public function menus()
    {
        return $this->hasMany('App\Model\Menu');
    }

    public function theme()
    {
        return $this->hasOne('App\Model\Theme');
    }

}